#ifndef __BDFUNC_H__
#define __BDFUNC_H__

#ifdef WIN32
	#define __MSC__
#endif

#include <glide.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include "bdtypes.h"
#include "reader.h"
#ifdef WIN32
#include "WINJPEG/jpeglib.h"
#else
#include "../src/lnxjpeg/jpeglib.h"
#include <unistd.h>
#endif

#define MK_PAT(pat, row) (((pat)<<16)|(row))
#define CLIP_DW(param) ((param)&0xffff0000)?0:(((param)>255)?255:(param))

// Win32
#ifdef WIN32
BOOL InitWindow(HINSTANCE hInstance);
void Setup(HINSTANCE);
// Unix
#else
void repSIGINT();
void Setup();
#endif


// Demo management
#define SelectTexture(tex) grTexSource(tex.tmu, tex.start, tex.evenOdd, &tex.info)

void ErrorMessage(char*);
DWORD Tick();

BOOL HardInit();
void ShutDown();
void InitModule(char*);
void ModuleShutDown();

void LoadObject(Obj3d*, DWORD, DWORD);

WORD* LoadJpeg2Array(DWORD, int*, int*);
void LoadJpeg2ArrayPrealloc(BYTE*, FILE*, int*, int*);
int PrepareTextureFromArray(WORD*, int, int, JpegTexture*);
int LoadTextureFromArray(WORD*, int, int, JpegTexture*);
int LoadJpegTexture(DWORD, JpegTexture*);
void DownloadTexture(JpegTexture*);
void FreeTexture(JpegTexture*);

// Demo init.
void LoadPictures();
void ComputeTables();
void PrepareVideo();

// capture
void Save_Screen();

void ComputeGouraud(Obj3d*);
void MulMatrix(float*, float*, float*);
void AddMatrix(float*, float*, float*);
void CopyMatrixSpecial(float*, float*);
void BeIdentityMatrix(float*);
void CopyMatrix(float*, float*);
void TranslateMatrix(float*, float, float, float);
void GeneralScaleMatrix(float*, float);
void ScaleXMatrix(float*, float);
void ScaleYMatrix(float*, float);
void ScaleZMatrix(float*, float);
void ScaleMatrix(float*, float, float, float);
void RotateXMatrix(float*, float*, int);
void RotateYMatrix(float*, float*, int);
void RotateZMatrix(float*, float*, int);
void ApplyMatrix(Obj3d*, float*);
void DrawWithMatrix(Obj3d*, float*, BOOL, float*, DWORD);
void Draw3dSprite(float, float, float*);
void Draw3dSpriteSimple(float, float, float, float, float);
void Draw3dSpriteEx(float, float, float, float,float, float, float*);
void DrawWithMatrixEnv(Obj3d*, float*, float*);
void DrawWithMatrixSowTow(Obj3d*, float*, BOOL, float*);

#endif
